/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	RosterOfTheDead
**
** DESCRIPTION:	Roster of the dead puzzle
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef ROSTEROFTHEDEAD_H
#define ROSTEROFTHEDEAD_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "ldwImage.h"
#include "Puzzle.h"
#include "../Collectables/CollectableInterface.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/
const int RosterOfTheDead_c_iMaxBushPieces = 8;
const ldwPoint RosterOfTheDead_c_sScaffoldingPos(1240, 1880);

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CRosterOfTheDead : public IPuzzle, public ICollectable
{
	friend class CPuzzle;

private:

	//class enumerations
	enum ERef
	{
		eRef_Bush = ePuzzle_RosterOfTheDead + (1 << 16),
		eRef_Scaffolding = ePuzzle_RosterOfTheDead + (2 << 16)
	};

	//class structures
	struct SSaveState
	{
	};

	//class data
	ldwImageGrid *	m_pBush;
	ldwImage *		m_pScaffolding;

	//class methods
	//setup
	public:		CRosterOfTheDead(void);
	public:		void Reset();
	public:		void LoadAssets();
	public:		void ReleaseAssets();
	public:		const int LoadState(const unsigned char *pData);
	public:		const int SaveState(const unsigned char *pData, const int iMaxDataSize) const;

	// process
	public:		void Draw() const;
	public:		void Draw(const int iRef) const;
	public:		void Complete();

	public:		const bool Carry(CVillager &Villager, const ECarrying eCarrying);
	public:		void Drop(CVillager &Villager, const ECarrying eCarrying);

	// access
	public:		const ECarrying GetNearbyCollectable(CVillager &Villager, const ldwPoint sPos);
	public:		const bool IsUncovered() const;
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CRosterOfTheDead		RosterOfTheDead;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/